"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketTransport = void 0;
const Transport_1 = require("../structures/Transport");
const RPCError_1 = require("../utils/RPCError");
const ws_1 = require("ws");
class WebSocketTransport extends Transport_1.Transport {
    constructor() {
        super(...arguments);
        Object.defineProperty(this, "ws", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
    }
    get isConnected() {
        return this.ws !== undefined && this.ws.readyState === 1;
    }
    connect() {
        return new Promise(async (resolve, reject) => {
            for (let i = 0; i < 10; i++) {
                const ws = await new Promise((resolve, reject) => {
                    const socket = new ws_1.WebSocket(`ws://127.0.0.1:${6463 + i}/?v=1&client_id=${this.client.clientId}&encoding=json`);
                    socket.onopen = () => {
                        socket.onclose = null;
                        socket.onopen = null;
                        resolve(socket);
                    };
                    socket.onerror = () => {
                        socket.onclose = null;
                        socket.onopen = null;
                        reject();
                    };
                }).catch(() => undefined);
                if (ws) {
                    this.ws = ws;
                    resolve();
                    break;
                }
            }
            if (!this.ws)
                reject(new RPCError_1.RPCError(Transport_1.CUSTOM_RPC_ERROR_CODE.COULD_NOT_CONNECT, "Failed to connect to websocket"));
            this.ws.onmessage = (event) => {
                this.emit("message", JSON.parse(event.data.toString()));
            };
            this.ws.onclose = (event) => {
                if (!event.wasClean)
                    return;
                this.ws = undefined;
                this.emit("close", event.reason);
            };
            this.ws.onerror = (event) => {
                try {
                    this.ws?.close();
                }
                catch { }
                throw event.error;
            };
            this.emit("open");
        });
    }
    send(data) {
        this.ws?.send(JSON.stringify(data));
    }
    ping() { }
    close() {
        if (!this.ws)
            return new Promise((resolve) => void resolve());
        return new Promise((resolve) => {
            this.ws.once("close", () => {
                this.emit("close", "Closed by client");
                this.ws = undefined;
                resolve();
            });
            this.ws.close();
        });
    }
}
exports.WebSocketTransport = WebSocketTransport;
