"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Channel = void 0;
const Message_1 = require("./Message");
const Base_1 = require("./Base");
class Channel extends Base_1.Base {
    constructor(client, props) {
        super(client);
        /**
         * channel id
         */
        Object.defineProperty(this, "id", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * channel's guild id
         */
        Object.defineProperty(this, "guild_id", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * channel name
         */
        Object.defineProperty(this, "name", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * channel type (guild text: 0, guild voice: 2, dm: 1, group dm: 3)
         */
        Object.defineProperty(this, "type", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * (text) channel topic
         */
        Object.defineProperty(this, "topic", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * (voice) bitrate of voice channel
         */
        Object.defineProperty(this, "bitrate", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * (voice) user limit of voice channel (0 for none)
         */
        Object.defineProperty(this, "user_limit", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * position of channel in channel list
         */
        Object.defineProperty(this, "position", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * (voice) channel's voice states
         */
        Object.defineProperty(this, "voice_states", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * (text) channel's messages
         */
        Object.defineProperty(this, "messages", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.assign(this, props);
        this.id = props.id;
        this.guild_id = props.guild_id;
        this.name = props.name;
        this.type = props.type;
        this.topic = props.topic;
        this.bitrate = props.bitrate;
        this.user_limit = props.user_limit;
        this.position = props.position;
        this.voice_states = props.voice_states;
        this.messages = props.messages?.map((messgeData) => new Message_1.Message(client, messgeData));
    }
}
exports.Channel = Channel;
