"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transport = exports.CUSTOM_RPC_ERROR_CODE = exports.RPC_ERROR_CODE = exports.RPC_CLOSE_CODE = void 0;
const async_event_emitter_1 = require("@vladfrangu/async_event_emitter");
var RPC_CLOSE_CODE;
(function (RPC_CLOSE_CODE) {
    RPC_CLOSE_CODE[RPC_CLOSE_CODE["CLOSE_NORMAL"] = 1000] = "CLOSE_NORMAL";
    RPC_CLOSE_CODE[RPC_CLOSE_CODE["CLOSE_UNSUPPORTED"] = 1003] = "CLOSE_UNSUPPORTED";
    RPC_CLOSE_CODE[RPC_CLOSE_CODE["CLOSE_ABNORMAL"] = 1006] = "CLOSE_ABNORMAL";
    RPC_CLOSE_CODE[RPC_CLOSE_CODE["INVALID_CLIENTID"] = 4000] = "INVALID_CLIENTID";
    RPC_CLOSE_CODE[RPC_CLOSE_CODE["INVALID_ORIGIN"] = 4001] = "INVALID_ORIGIN";
    RPC_CLOSE_CODE[RPC_CLOSE_CODE["RATELIMITED"] = 4002] = "RATELIMITED";
    RPC_CLOSE_CODE[RPC_CLOSE_CODE["TOKEN_REVOKED"] = 4003] = "TOKEN_REVOKED";
    RPC_CLOSE_CODE[RPC_CLOSE_CODE["INVALID_VERSION"] = 4004] = "INVALID_VERSION";
    RPC_CLOSE_CODE[RPC_CLOSE_CODE["INVALID_ENCODING"] = 4005] = "INVALID_ENCODING";
})(RPC_CLOSE_CODE || (exports.RPC_CLOSE_CODE = RPC_CLOSE_CODE = {}));
var RPC_ERROR_CODE;
(function (RPC_ERROR_CODE) {
    RPC_ERROR_CODE[RPC_ERROR_CODE["UNKNOWN_ERROR"] = 1000] = "UNKNOWN_ERROR";
    RPC_ERROR_CODE[RPC_ERROR_CODE["SERVICE_UNAVAILABLE"] = 1001] = "SERVICE_UNAVAILABLE";
    RPC_ERROR_CODE[RPC_ERROR_CODE["TRANSACTION_ABORTED"] = 1002] = "TRANSACTION_ABORTED";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_PAYLOAD"] = 4000] = "INVALID_PAYLOAD";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_COMMAND"] = 4002] = "INVALID_COMMAND";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_GUILD"] = 4003] = "INVALID_GUILD";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_EVENT"] = 4004] = "INVALID_EVENT";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_CHANNEL"] = 4005] = "INVALID_CHANNEL";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_PERMISSIONS"] = 4006] = "INVALID_PERMISSIONS";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_CLIENTID"] = 4007] = "INVALID_CLIENTID";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_ORIGIN"] = 4008] = "INVALID_ORIGIN";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_TOKEN"] = 4009] = "INVALID_TOKEN";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_USER"] = 4010] = "INVALID_USER";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_INVITE"] = 4011] = "INVALID_INVITE";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_ACTIVITY_JOIN_REQUEST"] = 4012] = "INVALID_ACTIVITY_JOIN_REQUEST";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_ENTITLEMENT"] = 4015] = "INVALID_ENTITLEMENT";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_GIFT_CODE"] = 4016] = "INVALID_GIFT_CODE";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_GUILD_TEMPLATE"] = 4017] = "INVALID_GUILD_TEMPLATE";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_SOUND"] = 4018] = "INVALID_SOUND";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_PROVIDER"] = 4019] = "INVALID_PROVIDER";
    RPC_ERROR_CODE[RPC_ERROR_CODE["OAUTH2_ERROR"] = 5000] = "OAUTH2_ERROR";
    RPC_ERROR_CODE[RPC_ERROR_CODE["SELECT_CHANNEL_TIMED_OUT"] = 5001] = "SELECT_CHANNEL_TIMED_OUT";
    RPC_ERROR_CODE[RPC_ERROR_CODE["GET_GUILD_TIMED_OUT"] = 5002] = "GET_GUILD_TIMED_OUT";
    RPC_ERROR_CODE[RPC_ERROR_CODE["SELECT_VOICE_FORCE_REQUIRED"] = 5003] = "SELECT_VOICE_FORCE_REQUIRED";
    RPC_ERROR_CODE[RPC_ERROR_CODE["INVALID_ACTIVITY_SECRET"] = 5005] = "INVALID_ACTIVITY_SECRET";
    RPC_ERROR_CODE[RPC_ERROR_CODE["NO_ELIGIBLE_ACTIVITY"] = 5006] = "NO_ELIGIBLE_ACTIVITY";
    RPC_ERROR_CODE[RPC_ERROR_CODE["PURCHASE_CANCELED"] = 5008] = "PURCHASE_CANCELED";
    RPC_ERROR_CODE[RPC_ERROR_CODE["PURCHASE_ERROR"] = 5009] = "PURCHASE_ERROR";
    RPC_ERROR_CODE[RPC_ERROR_CODE["UNAUTHORIZED_FOR_ACHIEVEMENT"] = 5010] = "UNAUTHORIZED_FOR_ACHIEVEMENT";
    RPC_ERROR_CODE[RPC_ERROR_CODE["RATE_LIMITED"] = 5011] = "RATE_LIMITED";
    RPC_ERROR_CODE[RPC_ERROR_CODE["UNAUTHORIZED_FOR_APPLICATION"] = 5012] = "UNAUTHORIZED_FOR_APPLICATION";
    RPC_ERROR_CODE[RPC_ERROR_CODE["NO_CONNECTION_FOUND"] = 5013] = "NO_CONNECTION_FOUND";
})(RPC_ERROR_CODE || (exports.RPC_ERROR_CODE = RPC_ERROR_CODE = {}));
var CUSTOM_RPC_ERROR_CODE;
(function (CUSTOM_RPC_ERROR_CODE) {
    CUSTOM_RPC_ERROR_CODE[CUSTOM_RPC_ERROR_CODE["CONNECTION_ENDED"] = 0] = "CONNECTION_ENDED";
    CUSTOM_RPC_ERROR_CODE[CUSTOM_RPC_ERROR_CODE["CONNECTION_TIMEOUT"] = 1] = "CONNECTION_TIMEOUT";
    CUSTOM_RPC_ERROR_CODE[CUSTOM_RPC_ERROR_CODE["COULD_NOT_CONNECT"] = 2] = "COULD_NOT_CONNECT";
})(CUSTOM_RPC_ERROR_CODE || (exports.CUSTOM_RPC_ERROR_CODE = CUSTOM_RPC_ERROR_CODE = {}));
class Transport extends async_event_emitter_1.AsyncEventEmitter {
    get isConnected() {
        return false;
    }
    constructor(options) {
        super();
        Object.defineProperty(this, "client", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this.client = options.client;
    }
}
exports.Transport = Transport;
