import type { ActivityType, GatewayActivityButton } from "discord-api-types/v10";
import type { CertifiedDevice } from "./CertifiedDevice";
import { VoiceSettings } from "./VoiceSettings";
import { Channel } from "./Channel";
import { Guild } from "./Guild";
import { User } from "./User";
export declare enum ActivitySupportedPlatform {
    IOS = "ios",
    ANDROID = "android",
    WEB = "web"
}
export declare enum ActivityPartyPrivacy {
    PRIVATE = 0,
    PUBLIC = 1
}
export type SetActivity = {
    /**
     * Minimum of 2 characters and maximum of 128 characters
     */
    state?: string;
    /**
     * Minimum of 2 characters and maximum of 128 characters
     */
    details?: string;
    startTimestamp?: number | Date;
    endTimestamp?: number | Date;
    /**
     * Minimum of 1 characters and maximum of 128 characters
     */
    largeImageKey?: string;
    /**
     * Minimum of 1 characters and maximum of 128 characters
     */
    smallImageKey?: string;
    /**
     * Minimum of 2 characters and maximum of 128 characters
     */
    largeImageText?: string;
    /**
     * Minimum of 2 characters and maximum of 128 characters
     */
    smallImageText?: string;
    /**
     * Minimum of 2 characters and maximum of 128 characters
     */
    partyId?: string;
    /**
     * Default: ActivityPartyPrivacy.PRIVATE
     */
    partyPrivacy?: ActivityPartyPrivacy;
    partySize?: number;
    partyMax?: number;
    /**
     * Minimum of 2 characters and maximum of 128 characters
     */
    matchSecret?: string;
    /**
     * Minimum of 2 characters and maximum of 128 characters
     */
    joinSecret?: string;
    /**
     * Minimum of 2 characters and maximum of 128 characters
     */
    spectateSecret?: string;
    instance?: boolean;
    buttons?: Array<GatewayActivityButton>;
    supportedPlatforms?: (ActivitySupportedPlatform | `${ActivitySupportedPlatform}`)[];
    /**
     * Default: ActivityTypes.PLAYING
     */
    type?: ActivityType.Playing | ActivityType.Listening | ActivityType.Watching | ActivityType.Competing;
};
export type SetActivityResponse = {
    state?: string;
    buttons?: string[];
    name: string;
    application_id: string;
    type: number;
    metadata: {
        button_urls?: string[];
    };
};
export declare class ClientUser extends User {
    fetchUser(userId: string): Promise<User>;
    /**
     * Used to get a guild the client is in.
     *
     * @param guildId - id of the guild to get
     * @param timeout - asynchronously get guild with time to wait before timing out
     * @returns partial guild
     */
    fetchGuild(guildId: string, timeout?: number): Promise<Guild>;
    /**
     * Used to get a list of guilds the client is in.
     * @returns the guilds the user is in
     */
    fetchGuilds(): Promise<Guild[]>;
    /**
     * Used to get a channel the client is in.
     * @param channelId - id of the channel to get
     * @returns partial channel
     */
    fetchChannel(channelId: string): Promise<Channel>;
    /**
     * Used to get a guild's channels the client is in.
     * @param guildId - id of the guild to get channels for
     * @returns guild channels the user is in
     */
    fetchChannels(guildId: string): Promise<Channel[]>;
    /**
     * Used to get the client's current voice channel. There are no arguments for this command. Returns the [Get Channel](https://discord.com/developers/docs/topics/rpc#getchannel) response, or `null` if none.
     * @returns the client's current voice channel, `null` if none
     */
    getSelectedVoiceChannel(): Promise<Channel | null>;
    /**
     * Used to join voice channels, group dms, or dms. Returns the [Get Channel](https://discord.com/developers/docs/topics/rpc#getchannel) response, `null` if none.
     * @param channelId - channel id to join
     * @param timeout - asynchronously join channel with time to wait before timing out
     * @param force - forces a user to join a voice channel
     * @returns the channel that the user joined, `null` if none
     */
    selectVoiceChannel(channelId: string | null, timeout: number, force: boolean, navigate: boolean): Promise<Channel>;
    /**
     * Used to leave voice channels, group dms, or dms
     * @param timeout - asynchronously join channel with time to wait before timing out
     * @param force - forces a user to join a voice channel
     */
    leaveVoiceChannel(timeout?: number, force?: boolean): Promise<void>;
    /**
     * Used to get current client's voice settings
     * @returns the voice setting
     */
    getVoiceSettings(): Promise<VoiceSettings>;
    /**
     * Used by hardware manufacturers to send information about the current state of their certified devices that are connected to Discord.
     * @param devices - a list of devices for your manufacturer, in order of priority
     * @returns
     */
    setCeritfiedDevices(devices: CertifiedDevice[]): Promise<void>;
    /**
     * Used to accept an Ask to Join request.
     * @param userId - the id of the requesting user
     */
    sendJoinInvite(userId: string): Promise<void>;
    /**
     * Used to reject an Ask to Join request.
     * @param userId - the id of the requesting user
     */
    closeJoinRequest(userId: string): Promise<void>;
    /**
     * Used to join text channels, group dms, or dms. Returns the [Get Channel](https://discord.com/developers/docs/topics/rpc#getchannel) response, or `null` if none.
     * @param channelId - channel id to join
     * @param timeout - asynchronously join channel with time to wait before timing out
     * @returns the text channel that user joined
     */
    selectTextChannel(channelId: string | null, timeout: number): Promise<Channel | null>;
    /**
     * Used to leave text channels, group dms, or dms.
     * @param timeout - asynchronously join channel with time to wait before timing out
     */
    leaveTextChannel(timeout?: number): Promise<void>;
    getRelationships(): Promise<Array<User>>;
    /**
     * Used to update a user's Rich Presence.
     *
     * @param activity - the rich presence to assign to the user
     * @param pid - the application's process id
     * @returns The activity that have been set
     */
    setActivity(activity: SetActivity, pid?: number): Promise<SetActivityResponse>;
    /**
     * Used to clear a user's Rich Presence.
     *
     * @param pid - the application's process id
     */
    clearActivity(pid?: number): Promise<void>;
    /**
     * Used to get a user's avatar
     * @param userId - id of the user to get the avatar of
     * @param format - image format
     * @param size - image size
     * @return base64 encoded image data
     */
    getImage(userId: string, format?: "png" | "webp" | "jpg", size?: 16 | 32 | 64 | 128 | 256 | 512 | 1024): Promise<string>;
    /**
     * Requires RPC and RPC_VOICE_WRITE
     * @returns
     */
    getSoundboardSounds(): Promise<any>;
    /**
     * Requires RPC and RPC_VOICE_WRITE
     * @returns
     */
    playSoundboardSound(guildId: string, soundId: string): Promise<any>;
    /**
     * Requires RPC and RPC_VIDEO_WRITE
     * @returns
     */
    toggleVideo(): Promise<any>;
    /**
     * Requires RPC and RPC_SCREENSHARE_WRITE
     * @returns
     */
    toggleScreenshare(pid?: number): Promise<any>;
    /**
     * Requires RPC and RPC_VOICE_WRITE
     * @returns
     */
    setPushToTalk(active: boolean): Promise<any>;
    /**
     * Requires RPC and RPC_VOICE_WRITE
     * @returns
     */
    setVoiceSettings(req: {
        user_id: string;
        pan: {
            left: number;
            right: number;
        };
        volume: number;
        mute: boolean;
    }): Promise<any>;
    /**
     * Requires RPC and RPC_VOICE_WRITE
     * @returns
     */
    setVoiceSettings2(req: {
        input_mode: {
            type: "PUSH_TO_TALK" | "VOICE_ACTIVITY";
            shortcut: string;
        };
        self_mute: boolean;
        self_deaf: boolean;
    }): Promise<any>;
    /**
     * Requires RPC and RPC_GUILDS_MEMBERS_READ
     * @returns
     */
    getChannelPermissions(): Promise<{
        permissions: any;
    }>;
    getActivityInstanceConnectedParticipants(): Promise<{
        participants: {
            nickname: string;
        }[];
    }>;
    navigateToConnections(): Promise<any>;
    createChanenlInvite(channelId: string, args: object): Promise<any>;
    openExternalLink(url: string): Promise<any>;
    getPlatformBehaviors(): Promise<{
        iosKeyboardResizesView: boolean;
    }>;
    getProviderAccessToken(provider: string, connectionRedirect: string): Promise<any>;
    maybeGetProviderAccessToken(provider: string): Promise<any>;
    getSKUS(): Promise<any>;
    getEntitlements(): Promise<any>;
    getSKUsEmbedded(): Promise<{
        skus: any;
    }>;
    getEntitlementsEmbedded(): Promise<{
        entitlements: any;
    }>;
    encourageHardwareAcceleration(): Promise<any>;
    captureLog(level: "log" | "warn" | "debug" | "info" | "error", message: string): Promise<any>;
    sendAnalyticsEvent(eventName: string, eventProperties: object): Promise<any>;
    getLocale(): Promise<string>;
    getAchievements(): Promise<any>;
    setAchievement(achievementId: string, percentComplete: number): Promise<any>;
    createNetworkingToken(): Promise<any>;
    networkingPeerMetrics(): Promise<any>;
    networkingSystemMetrics(): Promise<any>;
    getNetworkingConfig(): Promise<{
        address: any;
        token: any;
    }>;
    startPurchase(skuId: string, pid: number): Promise<any>;
    startPremiumPurchase(pid: number): Promise<any>;
    getApplicationTicket(): Promise<any>;
    getEntitlementTicket(): Promise<any>;
    validateApplication(): Promise<any>;
    openOverlayVoiceSettings(pid: number): Promise<any>;
    openOverlayGuildInvite(code: string, pid: number): Promise<any>;
    openOverlayActivityInvite(type: "JOIN", pid: number): Promise<any>;
    setOverlayLocked(locked: boolean, pid: number): Promise<any>;
    browserHandoff(): Promise<any>;
    openGuildTemplateBrowser(code: any): Promise<any>;
    openGiftCodeBrowser(code: any): Promise<any>;
    brainTreePopupBridgeCallback(state: any, path: any, query: any): Promise<any>;
    billingPopupBridgeCallback(state: any, path: any, query: any, paymentSourceType: any): Promise<any>;
    connectionsCallback(providerType: any, code: any, openIdParams: any, state: any): Promise<any>;
    deepLink(type: any, params: any): Promise<any>;
    inviteBrowser(code: any): Promise<any>;
    initiateImageUpload(): Promise<{
        image_url: string;
    }>;
    openShareMomentDialog(mediaUrl: string): Promise<any>;
    openInviteDialog(): Promise<any>;
    acceptActivityInvite(type: "JOIN", userId: string, sessionId: string, channelId: string, messageId: string): Promise<any>;
    activityInviteUser(userId: string, type: "JOIN", content: string, pid: number): Promise<any>;
    closeActivityJoinRequest(userId: string): Promise<any>;
    sendActivityJoinInvite(userId: string, pid: number): Promise<any>;
    setConfig(useInteractivePip: boolean): Promise<any>;
}
