import { type APIApplication, type OAuth2Scopes } from "discord-api-types/v10";
import { AsyncEventEmitter } from "@vladfrangu/async_event_emitter";
import { type PathData } from "./transport/IPC";
import { ClientUser } from "./structures/ClientUser";
import { type RPC_CMD, type CommandIncoming, type RPC_EVT, type Transport, type TransportOptions } from "./structures/Transport";
export type AuthorizeOptions = {
    scopes: (OAuth2Scopes | `${OAuth2Scopes}`)[];
    prompt?: "consent" | "none";
    useRPCToken?: boolean;
    refreshToken?: string;
};
export interface ClientOptions {
    /**
     * application id
     */
    clientId: string;
    /**
     * application secret
     */
    clientSecret?: string;
    /**
     * pipe id
     */
    pipeId?: number;
    /**
     * transport configs
     */
    transport?: {
        /**
         * transport type
         */
        type?: "ipc" | "websocket" | {
            new (options: TransportOptions): Transport;
        };
        /**
         * ipc transport's path list
         */
        pathList?: PathData[];
    };
}
export type ClientEvents = {
    /**
     * fired when the client is ready
     */
    ready: [];
    /**
     * fired when the client is connected to local rpc server
     */
    connected: [];
    /**
     * fired when the client is disconnected from the local rpc server
     */
    disconnected: [];
    /**
     * fired when the client is have debug message
     */
    debug: [...data: any];
} & {
    [K in Exclude<RPC_EVT, "READY">]: [unknown];
};
export declare class Client extends AsyncEventEmitter<ClientEvents> {
    #private;
    /**
     * application id
     */
    clientId: string;
    /**
     * application secret
     */
    clientSecret?: string;
    /**
     * pipe id
     */
    pipeId?: number;
    get user(): ClientUser | undefined;
    get application(): APIApplication | undefined;
    get transport(): Transport;
    get isConnected(): boolean;
    constructor(options: ClientOptions);
    /**
     * @hidden
     */
    request<A = any, D = any>(cmd: RPC_CMD, args?: any, evt?: RPC_EVT): Promise<CommandIncoming<A, D>>;
    private authenticate;
    private refreshAccessToken;
    private hanleAccessTokenResponse;
    private authorize;
    /**
     * Used to subscribe to events. `evt` of the payload should be set to the event being subscribed to. `args` of the payload should be set to the args needed for the event.
     * @param event event name now subscribed to
     * @param args args for the event
     * @returns an object to unsubscribe from the event
     */
    subscribe(event: Exclude<RPC_EVT, "READY" | "ERROR">, args?: any): Promise<{
        unsubscribe: () => void;
    }>;
    /**
     * connect to the local rpc server
     */
    connect(): Promise<void>;
    /**
     * will try to authorize if a scope is specified, else it's the same as `connect()`
     * @param options options for the authorization
     */
    login(options?: AuthorizeOptions): Promise<void>;
    /**
     * disconnects from the local rpc server
     */
    destroy(): Promise<void>;
    getCdn(): import("@discordjs/rest").CDN;
}
