"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const electron_1 = require("electron");
const config_js_1 = require("./config.js");
const platform_js_1 = require("./types/platform.js");
const Logger_js_1 = require("./packages/logger/Logger.js");
const systemMenu_js_1 = require("./lib/systemMenu.js");
const tray_js_1 = require("./lib/tray.js");
const singleInstance_js_1 = require("./lib/singleInstance.js");
const createWindow_js_1 = require("./lib/createWindow.js");
const updater_js_1 = require("./lib/updater.js");
const events_js_1 = require("./events.js");
const customTitleBar_js_1 = require("./lib/customTitleBar.js");
const loadURL_js_1 = require("./lib/loadURL.js");
const deviceInfo_js_1 = require("./lib/deviceInfo.js");
const safeRedirects_js_1 = require("./lib/safeRedirects.js");
const handleCrash_js_1 = require("./lib/handlers/handleCrash.js");
const handleExternalLink_js_1 = require("./lib/handlers/handleExternalLink.js");
const handleWindowLifecycleEvents_js_1 = require("./lib/handlers/handleWindowLifecycleEvents.js");
const handleDeeplink_js_1 = require("./lib/handlers/handleDeeplink.js");
const handleUncaughtException_js_1 = require("./lib/handlers/handleUncaughtException.js");
const handleWindowSessionEvents_js_1 = require("./lib/handlers/handleWindowSessionEvents.js");
const handleWindowReady_js_1 = require("./lib/handlers/handleWindowReady.js");
const handleHeadersReceived_js_1 = require("./lib/handlers/handleHeadersReceived/handleHeadersReceived.js");
const handleBackgroundTasks_js_1 = require("./lib/handlers/handleBackgroundTasks.js");
Logger_js_1.Logger.setupLogger();
(0, handleUncaughtException_js_1.handleUncaughtException)();
(0, singleInstance_js_1.checkForSingleInstance)();
(0, handleDeeplink_js_1.handleDeeplinkOnApplicationStartup)();
(async () => {
    const updater = (0, updater_js_1.getUpdater)();
    await electron_1.app.whenReady();
    (0, systemMenu_js_1.setupSystemMenu)();
    const window = await (0, createWindow_js_1.createWindow)();

const { Client } = require("@xhayper/discord-rpc");

const clientId = "1283109459463377011";
const discordActivityCooldown = 10 * 1000;
var lastActivityChanged = Date.now();

var rpc;
function initRpc(){
    rpc = new Client({ clientId: clientId });

    rpc.login().catch(e => {
        console.error("[DISCORD RPC]", e);
        setTimeout(initRpc, 3000);
    });

    rpc.on("ready", () => {
        console.log("[DISCORD RPC] Hooked!");
    });

    rpc.on("disconnected", () => {
        console.log("[DISCORD RPC] Disconnected");
        setTimeout(initRpc, 3000);
    });

    rpc.on("error", () => {
        console.log("[DISCORD RPC] Error");
        setTimeout(initRpc, 3000);
    });
    rpc.on("close", () => {
        console.log("[DISCORD RPC] Closed");
        setTimeout(initRpc, 3000);
    });

};


async function activityLoop() {
    setTimeout(activityLoop, 500);

    if (lastActivityChanged + discordActivityCooldown > Date.now()) return;

    if (!rpc.user) return;

    try {
        var playerState = await GetAppPlayerState();

        var startTimestamp = Date.now() - timeToTimestamp(playerState.timerStart) - 1000;
        var endTimestamp = Date.now() + timeToTimestamp(playerState.timerEnd) - timeToTimestamp(playerState.timerStart);

        var request = {
            type: 2,
            details: playerState.trackTitle,
            largeImageKey: playerState.trackImage,
            state: playerState.trackArtists,
            startTimestamp: startTimestamp,
            endTimestamp: endTimestamp,
            buttons: [
                {
                    label: "🎵 Открыть трек",
                    url: `https://music.yandex.ru/album/${playerState.trackId}`,
                },
                {
                    label: "💻 Yandex Music Mod",
                    url: `https://github.com/Stephanzion/YandexMusicBetaMod`,
                },
            ],
            instance: false,
        };

        if (playerState.isPlaying) {
            console.log("[DISCORD RPC] request:", request);
            rpc.user.setActivity(request);
        } else {
            console.log("[DISCORD RPC] clearActivity");
            rpc.user.clearActivity();
        }

        lastActivityChanged = Date.now();
    } catch (ex) {
        console.log("[DISCORD RPC]", ex);
    }
}

initRpc();
activityLoop();

function timeToTimestamp(timeStr) {
    const [minutes, seconds] = timeStr.split(":").map(Number);
    return (minutes * 60 + seconds) * 1000;
}
async function GetAppPlayerState() {
    return window.webContents.executeJavaScript(`
    
    (()=>{

        var player = document.querySelector('section[data-test-id="PLAYERBAR_DESKTOP"]') || document.querySelector('section[class*="PlayerBarMobile_root__"]') ;

        var titleElement = player.querySelector('a[data-test-id="TRACK_TITLE"]') || player.querySelector('span[class*="Meta_title__"]')
        var artistsElement = player.querySelector('span[class*="Meta_albumTitle__"]') || player.querySelectorAll('a[data-test-id="SEPARATED_ARTIST_TITLE"]')
        var trackTitle = titleElement.innerText.trim()
        var trackArtists = (artistsElement instanceof NodeList ? [...artistsElement] :  [artistsElement] ).map(x=>x.innerText.trim()).join(', ')
        var imageElement = player.querySelector('img[data-test-id="ENTITY_COVER"]') || player.querySelector('img[data-test-id="ENTITY_COVER_IMAGE"]')
        var trackImage = imageElement.src;
        var timerStart = player.querySelector('span[data-test-id="TIMECODE_TIME_START"]')?.innerText.trim()
        var timerEnd = player.querySelector('span[data-test-id="TIMECODE_TIME_END"]')?.innerText.trim()
        var idElement = player.querySelector('a[data-test-id="TRACK_TITLE"]') || player.querySelector('a[class*=Meta_link__]');
        var trackId = idElement.href.trim().split('=').at(-1);
        var isPlaying = !!player.querySelector('button[data-test-id="PAUSE_BUTTON"]');

        return {trackTitle,trackArtists,trackImage,timerStart,timerEnd,trackId,isPlaying};
        
    })()
    
    `);
}

// блокировка запросов аналитики и рекламы
const { session } = require("electron");

session.defaultSession.webRequest.onBeforeRequest({
    urls: ["https://yandex.ru/clck/*", "https://mc.yandex.ru/*", "https://api.music.yandex.net/dynamic-pages/trigger/*"] }, (details, callback) => {
  callback({ cancel: true });
});

// Яндекс Музыка\resources\app\main\index.js
// прикрепляется к строчке: const window = await (0, createWindow_js_1.createWindow)()

    if (deviceInfo_js_1.devicePlatform === platform_js_1.Platform.WINDOWS) {
        (0, tray_js_1.setupTray)(window);
    }
    (0, safeRedirects_js_1.safeRedirects)(window);
    (0, handleWindowReady_js_1.handleWindowReady)(window);
    (0, handleWindowLifecycleEvents_js_1.handleWindowLifecycleEvents)(window);
    (0, handleWindowSessionEvents_js_1.handleWindowSessionEvents)(window);
    (0, events_js_1.handleApplicationEvents)(window);
    (0, handleExternalLink_js_1.handleExternalLink)(window);
    (0, handleDeeplink_js_1.handleDeeplink)(window);
    (0, handleHeadersReceived_js_1.handleHeadersReceived)(window);
    (0, handleBackgroundTasks_js_1.handleBackgroundTasks)(window);
    (0, handleCrash_js_1.handleCrash)();
    await (0, loadURL_js_1.loadURL)(window);
    if ([platform_js_1.Platform.WINDOWS, platform_js_1.Platform.LINUX].includes(deviceInfo_js_1.devicePlatform)) {
        (0, customTitleBar_js_1.createCustomTitleBar)(window);
    }
    if (config_js_1.config.enableAutoUpdate) {
        updater.start();
        updater.onUpdate((version) => {
            (0, events_js_1.sendUpdateAvailable)(window, version);
        });
    }
})();
